import logging
from fastapi.responses import JSONResponse
from typing import Any


logger = logging.getLogger(__name__)


def exclude_route(is_exclude: bool) -> Any:
    def _available(func):
        return func

    def _unavailable(func):
        def unavailable_route():
            logger.info('%s was requested but it was exclude', func.__name__)
            return JSONResponse(status_code=404, content={'detail': 'Not Found'})
        return unavailable_route

    return _unavailable if is_exclude else _available
