"""
ВАЖНО! Эти ручки не для фронта, а только для дебага.
"""
import logging
from typing import Any
from fastapi import APIRouter, Request

from intranet.trip.src.enums import Language
from intranet.trip.src.lib.aviacenter.api import aviacenter
from intranet.trip.src.lib.aviacenter.fields import boolint
from intranet.trip.src.lib.aviacenter.models import (
    AviaSearchRequest,
    AviaBookIn,
    HotelBookIn,
    HotelSearchRequest,
    TrainSearchRequest,
    TrainBookIn,
)


logger = logging.getLogger(__name__)
router = APIRouter()


@router.get('/companies', status_code=200, response_model=dict[str, Any])
async def get_companies(
    limit: int = 10,
    offset: int = 0,
):
    return await aviacenter.get_companies(
        limit=limit,
        offset=offset,
    )


@router.get('/airports', status_code=200, response_model=dict[str, Any])
async def get_airports(
    request: Request,
    query: str = None,
    city_iata: str = None,
    lang: Language = None,
):
    return await aviacenter.get_airports(
        query=query,
        city_iata=city_iata,
        lang=lang or request.state.user.language or Language.ru,
    )


@router.post('/avia/search', status_code=201, response_model=dict[str, Any])
async def create_aviacenter_avia_search(search_request: AviaSearchRequest):
    return await aviacenter.create_avia_search(search_request)


@router.get('/avia/search/results', status_code=200, response_model=dict[str, Any])
async def get_aviacenter_avia_search_results(
    company_id: int,
    sro: str,
    travel_policy_id: int = None,
    is_async: boolint = 0,
):
    return await aviacenter.get_avia_search_results(company_id, sro, travel_policy_id, is_async)


@router.get('/avia/fare_families', status_code=200, response_model=dict[str, Any])
async def get_fare_families(company_id: int, tid: str, travel_policy_id: int = None):
    return await aviacenter.get_fare_families(company_id, tid, travel_policy_id)


@router.get('/avia/flight_info', status_code=200, response_model=dict[str, Any])
async def get_flight_info(company_id: int, tid: str, travel_policy_id: int = None):
    return await aviacenter.get_flight_info(company_id, tid, travel_policy_id)


@router.get('/avia/rules', status_code=200, response_model=dict[str, Any])
async def get_rules(tid: str):
    return await aviacenter.get_rules(tid=tid)


@router.post('/avia/book', status_code=200, response_model=dict[str, Any])
async def avia_book(avia_book_in: AviaBookIn):
    return await aviacenter.book_avia(avia_book_in)


@router.post('/hotel/search', status_code=201, response_model=dict[str, Any])
async def create_aviacenter_hotel_search(search_request: HotelSearchRequest):
    return await aviacenter.create_hotel_search(search_request)


@router.get('/hotel/search/results', status_code=200, response_model=dict[str, Any])
async def get_aviacenter_hotel_search_results(
    company_id: int,
    search_id: str,
    travel_policy_id: int = None,
):
    return await aviacenter.get_hotel_search_results(company_id, search_id, travel_policy_id)


@router.get('/hotel/search/view', status_code=200, response_model=dict[str, Any])
async def get_hotel_search_view(company_id: int, search_id: str):
    return await aviacenter.get_hotel_search_view(company_id, search_id)


@router.post('/hotel/book', status_code=200, response_model=dict[str, Any])
async def hotel_book(hotel_book_in: HotelBookIn):
    return await aviacenter.hotel_book(hotel_book_in)


@router.get('/order/{billing_number}', status_code=200, response_model=dict[str, Any])
async def order_detail(billing_number: int):
    return await aviacenter.get_order(billing_number)


@router.post('/train/search', status_code=201, response_model=dict[str, Any])
async def create_train_search(
    request: Request,
    search_request: TrainSearchRequest,
    lang: Language = None,
):
    return await aviacenter.create_train_search(
        search_request=search_request,
        lang=lang or request.state.user.language or Language.ru,
    )


@router.get('/train/search', status_code=200, response_model=dict[str, Any])
async def get_train_search(
    request: Request,
    company_id: int,
    search_id: str,
    lang: Language = None,
):
    return await aviacenter.get_train_search(
        company_id=company_id,
        search_id=search_id,
        lang=lang or request.state.user.language or Language.ru,
    )


@router.get('/train/info', status_code=200, response_model=dict[str, Any])
async def get_train_info(
    company_id: int,
    search_id: str,
    train_number: str,
    departure_time: str,
):
    return await aviacenter.get_train_info(
        company_id=company_id,
        search_id=search_id,
        train_number=train_number,
        departure_time=departure_time,
    )


@router.post('/train/book', status_code=200, response_model=dict[str, Any])
async def train_book(train_book_in: TrainBookIn):
    return await aviacenter.train_book(train_book_in)
