import logging

from fastapi import APIRouter, Depends

from intranet.library.fastapi_csrf.src import csrf_exempt

from intranet.trip.src.api.depends import get_unit_of_work, only_for_tvm
from intranet.trip.src.lib.utils import safe_getitem
from intranet.trip.src.logic.bot import get_message_processors
from intranet.trip.src.unit_of_work import UnitOfWork


logger = logging.getLogger(__name__)
router = APIRouter()


@router.post('/webhook')
@csrf_exempt
async def webhook(
    message: dict,
    _auth=Depends(only_for_tvm('bot')),
    uow: UnitOfWork = Depends(get_unit_of_work(read_only=True)),
):
    person = message.get('from')
    chat_id = safe_getitem(message, ['chat', 'id'])

    for processor_class, data in get_message_processors(message):
        if not person or not chat_id or not data or person.get('is_bot'):
            continue

        message_processor = processor_class(uow, person, chat_id)
        await message_processor.process(data)

    return {}
