import logging

from fastapi import APIRouter, Request

from intranet.trip.src.api.schemas import UserResponse
from intranet.trip.src.logic.persons import complement_user_contacts


logger = logging.getLogger(__name__)
router = APIRouter()


@router.get('/', response_model=UserResponse)
async def auth_meta(request: Request):
    return await complement_user_contacts(request.state.user)
