import logging
from fastapi import APIRouter, Depends, Request, Response

from intranet.library.fastapi_csrf.src import csrf_exempt

from intranet.trip.src.api.depends import get_unit_of_work
from intranet.trip.src.api.schemas import ApprovementData
from intranet.trip.src.config import settings
from intranet.trip.src.exceptions import PermissionDenied
from intranet.trip.src.lib.ok.api import OkClient
from intranet.trip.src.logic.ok import fill_approvement_data
from intranet.trip.src.unit_of_work import UnitOfWork


logger = logging.getLogger(__name__)
router = APIRouter()


@router.post('/create', status_code=200, response_class=Response)
@csrf_exempt
async def create_approvement(
    request: Request,
    approvement_data: ApprovementData,
    uow: UnitOfWork = Depends(get_unit_of_work(read_only=True)),
):
    if request.state.user.login != settings.TRIP_ROBOT_LOGIN:
        logger.warning('Trying to create approvement by %s', request.state.user.login)
        raise PermissionDenied(status_code=403)

    ok = OkClient(
        host=settings.ok_url,
        token=settings.OK_ROBOT_OAUTH,
        timeout=10,
    )

    if settings.ENABLE_AUTOMATIC_APPROVAL:
        await fill_approvement_data(
            uow=uow,
            approvement_data=approvement_data,
        )

    await ok.create_approvement(data=approvement_data.dict())
