import logging

from fastapi import APIRouter, Depends

from intranet.trip.src.api.schemas import SuggestResponse
from intranet.trip.src.enums import ServiceType
from intranet.trip.src.api.depends import get_provider_gateway
from intranet.trip.src.logic.providers import ProviderGateway


logger = logging.getLogger(__name__)
router = APIRouter()


@router.get(
    '/cities',
    responses={200: {'model': list[SuggestResponse]}},
    summary='Саджест по городам',
)
async def city_suggest(
    query: str,
    service_type: ServiceType,
    provider_gateway: ProviderGateway = Depends(get_provider_gateway),
):
    return await provider_gateway.city_suggest(query=query, service_type=service_type)
