import logging

from fastapi import APIRouter, Depends, Request

from intranet.trip.src.api.depends import get_unit_of_work
from intranet.trip.src.api.schemas import Purpose
from intranet.trip.src.unit_of_work import UnitOfWork


logger = logging.getLogger(__name__)
router = APIRouter()


@router.get('/', response_model=list[Purpose])
async def purpose_list(
    request: Request,
    uow: UnitOfWork = Depends(get_unit_of_work(read_only=True)),
):
    purposes = await uow.purposes.get_all()
    for purpose in purposes:
        if request.state.user.language == 'en':
            purpose.name = purpose.name_en
    return purposes
