import logging

from fastapi import APIRouter, Depends, Request, Response, UploadFile
from intranet.library.fastapi_csrf.src import csrf_exempt

from intranet.trip.src.api.depends import get_unit_of_work, only_for_tvm
from intranet.trip.src.unit_of_work import UnitOfWork

logger = logging.getLogger(__name__)
router = APIRouter()


@router.post('/', status_code=201, response_class=Response)
@csrf_exempt
async def upload_registry(
    registry_file: UploadFile,
    request: Request,
    _auth=Depends(only_for_tvm('trip')),
    uow: UnitOfWork = Depends(get_unit_of_work(read_only=True)),
):
    # s3_client = TripS3Client()
    logger.info(
        's3 file uploaded %s', registry_file.filename
    )
