import logging

from fastapi import APIRouter, Request

from intranet.library.fastapi_csrf.src import generate_csrf_token

from intranet.trip.src.api.schemas import TokenResponse
from intranet.trip.src.config import settings


logger = logging.getLogger(__name__)
router = APIRouter()


@router.get('/', response_model=TokenResponse)
async def get_csrf_token(request: Request):
    uid = request.state.user.uid
    ya_uid = request.cookies.get('yandexuid')
    return TokenResponse(csrf_token=generate_csrf_token(uid, ya_uid, settings.SECRET_KEY))
