import logging
from fastapi import APIRouter, Depends

from intranet.trip.src.api.auth import get_tvm_service_ticket
from intranet.trip.src.api.schemas import AirlineInfo, RoadInfo, RestrictionsInfo
from intranet.trip.src.config import settings
from intranet.trip.src.lib.travel.api import TravelAviaClient, TravelTrainClient


logger = logging.getLogger(__name__)
router = APIRouter()


@router.get('/airline_info', response_model=dict[str, AirlineInfo])
async def get_airline_info():
    travel_avia = TravelAviaClient(
        host=settings.travel_avia_url,
        service_ticket=await get_tvm_service_ticket('travel_avia'),
    )
    airline_info = await travel_avia.get_airline_info()
    return airline_info.get('data')


@router.get('/get_train_details', response_model=dict)
async def get_train_details(
    road_info=Depends(RoadInfo),
):
    travel_train = TravelTrainClient(
        host=settings.travel_train_url,
        service_ticket=await get_tvm_service_ticket('travel_train'),
    )
    train_details = await travel_train.get_train_details(**road_info.dict())
    return train_details


@router.get('/covid_restrictions', response_model=RestrictionsInfo)
async def get_covid_restrictions(country_code: int):
    travel_avia = TravelAviaClient(
        host=settings.travel_avia_url,
        service_ticket=await get_tvm_service_ticket('travel_avia'),
    )
    restrictions_info = await travel_avia.get_covid_restrictions(country_code)
    return restrictions_info.get('data')
