from datetime import datetime
from pydantic import BaseModel, root_validator

from intranet.trip.src.enums import EmployeeStatus
from intranet.trip.src.models.employee import EmployeeActions


class Approver(BaseModel):
    approver_id: int
    first_name: str
    last_name: str
    middle_name: str = None


class Employee(BaseModel):
    employee_id: int
    company_id: int
    first_name: str
    last_name: str
    middle_name: str = None
    email: str
    is_active: bool
    is_dismissed: bool
    is_coordinator: bool
    rejected_at: datetime = None
    status: EmployeeStatus = EmployeeStatus.activated
    approver: Approver
    actions: EmployeeActions

    @root_validator(pre=True)
    def set_status(cls, values):
        if values.get('rejected_at') is not None:
            values['status'] = EmployeeStatus.rejected
        elif values['is_dismissed']:
            values['status'] = EmployeeStatus.blocked
        elif not values['is_active']:
            values['status'] = EmployeeStatus.wait_activation
        return values
