from pydantic import BaseModel, root_validator

from intranet.trip.src.lib.utils import unify_values


class NotificationSyncIn(BaseModel):
    aeroclub_journey_id: int = None
    aeroclub_trip_id: int = None
    # TODO: вернуть обязательность полей ниже после удаления aeroclub_*_id
    provider_trip_id: int = None
    provider_journey_id: int = None

    @root_validator(pre=True)
    def set_provider_ids(cls, values):
        values = unify_values(values, ['provider_trip_id', 'aeroclub_trip_id'])
        values = unify_values(values, ['provider_journey_id', 'aeroclub_journey_id'])
        if not values.get('provider_trip_id') and not values.get('provider_journey_id'):
            raise ValueError('provider_trip_id and provider_journey_id are ')
        return values


class EventServiceIn(BaseModel):
    aeroclub_order_id: int
    aeroclub_service_id: int


class EventIn(BaseModel):
    code: str
    aeroclub_journey_id: int = None
    aeroclub_trip_id: int = None
    services: list[EventServiceIn] = None
    # TODO: вернуть обязательность полей ниже после удаления aeroclub_*_id
    provider_trip_id: int = None
    provider_journey_id: int = None

    @root_validator(pre=True)
    def set_provider_ids(cls, values):
        values = unify_values(values, ['provider_trip_id', 'aeroclub_trip_id'])
        values = unify_values(values, ['provider_journey_id', 'aeroclub_journey_id'])
        if not values.get('provider_trip_id') and not values.get('provider_journey_id'):
            raise ValueError('provider_trip_id and provider_journey_id are ')
        return values
