from datetime import datetime

from pydantic import BaseModel

from intranet.trip.src.enums import RestrictionStatus


class TravelBaggage(BaseModel):
    width: int = None
    length: int = None
    dimensions_sum: int = None
    height: int = None


class Tariff(BaseModel):
    id: int
    carryon: bool
    baggage_pieces: int = None
    baggage_allowed: bool
    description: str
    carryon_norm: float = None
    mask: str
    published: bool
    avia_company_id: int
    baggage_norm: float = None


class AirlineInfo(BaseModel):
    carryon: TravelBaggage
    iata: str = None
    default_tariff: Tariff = None
    baggage: TravelBaggage


class RoadInfo(BaseModel):
    station_from: int
    station_to: int
    when: datetime
    number: str


class RestrictionsInfo(BaseModel):
    country_id: int
    country_title_ru: str = None
    tourism: RestrictionStatus
    quarantine: RestrictionStatus
    quarantine_days: int
    visa: RestrictionStatus
    avia: RestrictionStatus
