from pydantic import root_validator

from intranet.trip.src.api.schemas import Person
from intranet.trip.src.config import settings


class UserResponse(Person):  # TODO: UserResponse -> User
    timezone: str
    language: str
    display_covid_message: bool
    is_b2b: bool = False
    display_tracker_issues: bool = True
    display_messenger_chats: bool = True
    is_coordinator: bool = False
    is_yandex_employee: bool = False
    avatar_id: str = None

    @root_validator(pre=True)
    def fill_flags(cls, values: dict) -> dict:
        values['is_b2b'] = not settings.IS_YA_TEAM
        values['display_tracker_issues'] = settings.IS_YA_TEAM
        values['display_messenger_chats'] = settings.IS_YA_TEAM
        return values
