from pydantic.error_wrappers import ErrorWrapper


async def db_validate_by_ids(gateway, model, field_name):
    ids = getattr(model, field_name)
    if not ids:
        return
    mapping = await gateway.check_if_exists(ids)
    for i, id_ in enumerate(ids):
        if not mapping[id_]:
            return ErrorWrapper(ValueError(), loc=(field_name, i))
