from typing import Optional


class Cache:
    CACHE_KEY_PREFIX = 'cache'

    def __init__(self, redis):
        self._redis = redis

    async def set(self, key: str, data: str, expire_after: Optional[int] = None):
        """
        Добавить данные в кеш (с возможностью опционально установить время инвалидации)
        """
        cache_key = f'{self.CACHE_KEY_PREFIX}:{key}'
        await self._redis.set(cache_key, data)
        if expire_after is not None:
            await self._redis.expire(cache_key, expire_after)

    async def get(self, key: str) -> Optional[str]:
        """
        Получить данные из кеша (в случае отсутствия вернется None)
        """
        cache_key = f'{self.CACHE_KEY_PREFIX}:{key}'
        return await self._redis.get(cache_key, encoding='utf-8')
