from pydantic import Field

from .default import Settings as DefaultSettings


class Settings(DefaultSettings):
    ENV_TYPE: str = 'development'

    POSTGRES_DATABASE: str = Field('trip', env='PG_LOCAL_DATABASE')
    POSTGRES_USER: str = Field('trip', env='PG_LOCAL_USER')
    POSTGRES_PASSWORD: str = Field('trip', env='PG_LOCAL_PASSWORD')
    POSTGRES_HOST: str = Field('localhost', env='PG_LOCAL_HOST')
    POSTGRES_PORT: int = Field(5432, env='PG_LOCAL_PORT')
    POSTGRES_COLLATION: str = 'C.UTF-8'

    ENABLE_PYSCOPG2 = False
    ENABLE_CSRF_PROTECTION = False
