from .default import Settings as DefaultSettings


class Settings(DefaultSettings):
    ENV_TYPE: str = 'production'
    DEBUG: bool = False

    REDIS_SENTINEL_MASTER = 'trip-prod-redis'

    TVM_CLIENT_ID: int = 2020755
    TVM_STAFF_ID: int = 2000054
    TVM_STAFF_API_ID: int = 2001974
    TVM_INTRASEARCH_ID: int = 2001043
    TVM_MESSENGER_ID: int = 2000482
    TVM_BOT_ID: int = 2000473
    TVM_IDM_ID: int = 2001600
    TVM_TRAVEL_AVIA_ID: int = 2000567
    TVM_TRAVEL_TRAIN_ID: int = 2002850
    TVM_DRIVE_ID: int = 2000615
    TVM_OK_ID: int = 2009215
    TVM_LOGBROKER_ID: int = 2001059
    TVM_PASSPORT_CONTACTS_ID: int = 2029756

    TRIP_HOST: str = 'trip.yandex-team.ru'
    STAFF_HOST: str = 'staff.yandex-team.ru'
    STAFF_API_HOST: str = 'staff-api.yandex-team.ru'
    SEARCH_HOST: str = 'search-back.yandex-team.ru'
    TRACKER_API_HOST: str = 'st-api.yandex-team.ru'
    PASSPORT_CONTACTS_API_HOST: str = 'address-prod.pers.yandex.net'

    MESSENGER_HOST: str = 'messenger-internal.yandex.net'
    BOT_MESSENGER_HOST: str = 'bp.mssngr.yandex.net'
    MESSENGER_UI_HOST: str = 'q.yandex-team.ru'

    TRAVEL_AVIA_HOST: str = 'api-gateway.production.avia.yandex.net'
    TRAVEL_TRAIN_HOST: str = 'production.train-api.rasp.internal.yandex.net'

    DRIVE_API_HOST: str = 'admin.carsharing.yandex.net'

    AEROCLUB_API_URL: str = 'https://api.aeroclub.ru/'
    HUB_API_URL: str = 'https://integration.aeroclub.ru/hub/'
    OPENAPI_URL: str = None

    AEROCLUB_PROFILE_ID = 2431035  # Test User
    CONF_MANAGER_LOGIN: str = 'sveta-shin'

    OK_HOST: str = 'ok.yandex-team.ru'

    ENABLE_ERROR_BOOSTER: bool = True
    ERROR_BOOSTER_PROJECT_ID: str = 'trip-back-production'
    LOGBROKER_ERROR_BOOSTER_TOPIC: str = '/trip/error-booster'

    YT_PREFIX: str = '//home/oebs/production/travel_expenses/travel_registers/'
    YT_ENABLE_SYNC: bool = True

    ZORA_CLIENT_ID: str = 'trip_production'

    MDS_S3_BUCKET_NAME: str = 'trip-back-ya-team'
