from aiopg.sa import create_engine
from pyscopg2.aiopg_sa import PoolManager

from intranet.trip.src.config import settings


async def get_db_engine():
    if settings.ENABLE_PYSCOPG2:
        return PoolManager(
            dsn=settings.multihost_db_url,
            acquire_timeout=settings.POSTGRES_ACQUIRE_TIMEOUT,
            refresh_timeout=settings.POSTGRES_REFRESH_TIMEOUT,
            pool_factory_kwargs=settings.db_pool_config,
        )
    else:
        return await create_engine(
            **settings.db_settings,
            **settings.db_pool_config,
        )


async def init_pg(app):
    app.state.db = await get_db_engine()


async def close_pg(app):
    if settings.ENABLE_PYSCOPG2:
        await app.state.db.close()
    else:
        app.state.db.close()
        await app.state.db.wait_closed()
