from sqlalchemy import select
from intranet.trip.src.db.gateways.base import DBGateway, RecordNotFound
from intranet.trip.src.db.tables import holding_table
from intranet.trip.src.models import Holding


class HoldingGateway(DBGateway):

    table = holding_table
    pk = 'holding_id'
    model_class = Holding

    async def get_holding(self, holding_id: int) -> Holding:
        return await self._get_one(
            select_list=[holding_table],
            where_clause=holding_table.c.holding_id == holding_id,
        )

    async def delete(self, holding_id: int) -> None:
        query = holding_table.delete().where(holding_table.c.holding_id == holding_id)
        await self.conn.execute(query)

    async def get_all_holding_ids(self) -> list[int]:
        query = select([holding_table.c.holding_id])
        rows = await self._fetchall(query)
        return [row['holding_id'] for row in rows]

    async def update(self, holding_id: int, **fields: dict) -> int:
        holding_id = await super().update(holding_id, **fields)
        if not holding_id:
            raise RecordNotFound('Holding is not found')
        return holding_id
