from sqlalchemy import select

from intranet.trip.src.db.gateways.base import DBGateway
from intranet.trip.src.db.tables import purpose_table
from intranet.trip.src.models import Purpose


class PurposeGateway(DBGateway):

    table = purpose_table
    pk = 'purpose_id'

    async def get_all(self) -> list[Purpose]:
        query = select([purpose_table]).order_by('name')
        rows = await self._fetchall(query)
        return [Purpose(**row) for row in rows]
