from sqlalchemy import select

from intranet.trip.src.db.gateways.base import DBGateway
from intranet.trip.src.db.tables import (
    registry_metadata_table
)
from intranet.trip.src.models import Registry


class RegistryGateway(DBGateway):
    table = registry_metadata_table
    model_class = Registry

    async def find_meta(
        self,
        s3_key: str,
    ) -> Registry:
        """
        Возвращает метаинформацию по ключу реестра в S3
        """
        query = (
            select([registry_metadata_table])
            .where(
                registry_metadata_table.c.s3_key == s3_key
            )

        )
        row = await self._first(query)
        if row is None:
            return None
        return Registry(**row)
