from enum import Enum


class Provider(str, Enum):
    aeroclub = 'aeroclub'
    aviacenter = 'aviacenter'


class TripType(str, Enum):
    conf = 'conf'
    trip = 'trip'
    trip_conf = 'trip_conf'


class TripStatus(str, Enum):
    new = 'new'
    cancelled = 'cancelled'
    closed = 'closed'


class PTStatus(str, Enum):
    draft = 'draft'  # командировка создана, но пользователь пока не подтвердил свое участие
    new = 'new'  # командировка создана и подтвержедна участником, услуги на стадии добавления
    verification = 'verification'  # командировка отправлена на проверку координатору (Казахстан)
    executing = 'executing'  # услуги отправлены на оформление
    executed = 'executed'  # все услуги оформлены
    cancelled = 'cancelled'  # командировка отменена
    closed = 'closed'  # командировка завершена


class CombinedStatus(str, Enum):
    draft = 'draft'
    under_approval = 'under_approval'
    approved = 'approved'
    verification = 'verification'
    executing = 'executing'
    executed = 'executed'
    cancelled = 'cancelled'
    closed = 'closed'


class TripDaysOffCompensations(str, Enum):
    money = 'money'
    days_off = 'days_off'


class CurrencyType(str, Enum):
    other = 'other'
    uah = 'uah'
    rub = 'rub'
    usd = 'usd'
    eur = 'eur'


class DocumentType(str, Enum):
    other = 'other'
    passport = 'passport'
    external_passport = 'external_passport'
    visa = 'visa'
    bonus_card = 'bonus_card'


class PurposeKind(Enum):
    """Тип цели: бывают цели, присущие только конференциям или только поездкам"""
    any = 'any'
    travel = 'travel'
    conf_inner = 'conf_inner'
    conf_external = 'conf_external'


class Gender(str, Enum):
    """Пол"""
    male = 'male'
    female = 'female'


class ConferenceParticiationType(str, Enum):
    speaker = 'speaker'
    listener = 'listener'
    recruiter = 'recruiter'


class Citizenship(str, Enum):
    OTHER = 'OTHER'
    RU = 'RU'  # Russia
    BY = 'BY'  # Belarus
    UA = 'UA'  # Ukraine
    KZ = 'KZ'  # Kazakhstan
    KG = 'KG'  # Kyrgyzstan
    AM = 'AM'  # Armenia
    UZ = 'UZ'  # Uzbekistan
    LV = 'LV'  # Latvia
    TJ = 'TJ'  # Tajikistan


class ServiceStatus(str, Enum):
    draft = 'draft'  # Услуга добавлена в командировку, но никакой процесс запущен не был
    new = 'new'  # DEPRECATED:  В услугу добавлен участник и документы, услуга готова к оформлению
    verification = 'verification'  # Услуга отправлена на проверку координатору
    in_progress = 'in_progress'  # Услуга обрабатывается (авторизуется, резервируется и т.п.)
    reserved = 'reserved'  # Услуга забронирована
    executed = 'executed'  # Услуга оформлена
    cancelled = 'cancelled'  # Услуга отменена (по ней уже был начат процесс в АК)
    deleted = 'deleted'  # Услуга удалена (процесса в АК начато не было, либо в АК такой услуги нет)


class ServiceType(str, Enum):
    avia = 'avia'
    hotel = 'hotel'
    rail = 'rail'


class PersonRole(str, Enum):
    chief = 'chief'
    hr_partner = 'hr_partner'
    approver = 'approver'


class RelationType(str, Enum):
    personal = 'personal'
    direct_subordinates = 'direct_subordinates'
    all_subordinates = 'all_subordinates'


class OverpriceWorkflow(str, Enum):
    extra_payment = 'extra_payment'
    difficult_approve = 'difficult_approve'


class ExtPersonStatus(str, Enum):
    pending = 'pending'
    completed = 'completed'
    cleaned = 'cleaned'


class RestrictionStatus(str, Enum):
    yes = 'yes'
    no = 'no'
    unknown = 'unknown'


class Language(str, Enum):
    ru = 'ru'
    en = 'en'


class ObjectType(str, Enum):
    city = 'city'
    country = 'country'
    airport = 'airport'
    carrier = 'carrier'
    aircraft = 'aircraft'
    terminal = 'terminal'
    train_station = 'train_station'


class SearchStatus(str, Enum):
    completed = 'completed'
    in_progress = 'in_progress'
    error = 'error'


class FilterValueType(str, Enum):
    boolean = 'boolean'
    integer = 'integer'
    time = 'time'
    select = 'select'  # пока таких фильтров нет, но мало ли
    multiselect = 'multiselect'
    string = 'string'


# Enums for Balance
class BalanceStatus(str, Enum):
    ok = 'ok'
    warning = 'warning'
    empty = 'empty'


class TransactionType(str, Enum):
    refund = 'refund'
    purchase = 'purchase'
    exchange = 'exchange'


class TransactionServiceType(str, Enum):
    avia = 'avia'
    hotel = 'hotel'
    rail = 'rail'
    transfer = 'transfer'
    vip_lounge = 'vip_lounge'
    fast_track = 'fast_track'
    additional = 'additional'
    aeroexpress = 'aeroexpress'
    insurance = 'insurance'


class TransactionStatus(str, Enum):
    paid = 'paid'  # Услуга оформлена и оплачена
    verified = 'verified'  # Транзакция сверена с реестром готова к отправке в Биллинг
    completed = 'completed'  # Услуга отправлена в Биллинг


class SearchOrdering(str, Enum):
    price = 'price'
    duration = 'duration'
    departure_time = 'departure_time'
    arrival_time = 'arrival_time'
    contract = 'contract'
    favorite = 'favorite'


class RegistryStatus(str, Enum):
    """
    Список статусов синка реестра: создан, готовы отправить в биллинг, отправили в биллинг
    """
    created = 'created'  # реестр вычитан и добавлен в базу
    ready_to_send = 'ready_to_send'  # готовы отправить в биллинг
    sent = 'sent'  # отправили в биллинг


class EmployeeStatus(str, Enum):
    """
    List of employee statuses for the company page
    """
    wait_activation = 'wait_activation'  # ожидает активации
    activated = 'activated'  # активирован
    blocked = 'blocked'  # доступ закрыт
    rejected = 'rejected'  # активация отклонена
