import logging

logger = logging.getLogger(__name__)


class PermissionDenied(Exception):

    def __init__(self, status_code: int = 404, log_message='Forbidden'):
        """
        :param status_code: код ответа, который будет передан на фронт.
        По умолчанию 404, потому что по требованию СИБ делаем
        одинаковые ответы в случаях, если ресурс не найден или
        если к нему нет доступа – BTRIP-2586
        """
        assert status_code in [403, 404]

        self.status_code = status_code
        self.detail = 'Not found' if self.status_code == 404 else 'Forbidden'

        logger.warning('%s. Returned status code is %s', log_message, status_code)


class WorkflowError(Exception):
    pass


class BadCompanyError(WorkflowError):
    msg_template = 'Organization `{company_name}` does not have related Aeroclub company'

    def __init__(self, company_name):
        msg = self.msg_template.format(company_name=company_name)
        super().__init__(msg)
