"""
Скрипт для удобства работы в шеле в контейнерах Deploy
"""
from intranet.trip.src.config import settings  # noqa
from intranet.trip.src.db import get_db_engine
from intranet.trip.src.lib.aeroclub.api import aeroclub  # noqa
from intranet.trip.src.lib.aviacenter.api import aviacenter  # noqa
from intranet.trip.src.redis import create_redis_pool
from intranet.trip.src.unit_of_work import UnitOfWork


async def get_uow():
    db = await get_db_engine()
    redis = await create_redis_pool()
    conn = await db.acquire()
    return UnitOfWork(conn=conn, redis=redis)
