from enum import Enum


class ReferenceType(str, Enum):
    undefined = 'Undefined'
    country = 'Country'
    city = 'City'
    railway_station = 'RailwayStation'
    hotel = 'Hotel'
    airport = 'Airport'
    airline = 'Airline'
    airline_alliance = 'AirlineAlliance'
    railway_station_id = 'RailwayStationId'


class ACServiceType(str, Enum):
    """
    Тут добавлен префикс AC(Aeroclub), чтобы не было конфликта с другим enum ServiceType
    """
    avia = 'Avia'
    rail = 'Rail'
    hotel = 'Hotel'


class AuthorizationAssertion(str, Enum):
    not_supported = 'NotSupported'
    required = 'Required'
    not_required = 'NotRequired'


class AuthorizationStatus(str, Enum):
    not_supported = 'NotSupported'
    pending = 'Pending'
    in_progress = 'InProgress'
    authorized = 'Authorized'
    not_authorized = 'NotAuthorized'
    recalled = 'Recalled'


class ServiceAction(str, Enum):
    unknown = 'Unknown'
    contact_operator = 'ContactOperator'
    cancel = 'Cancel'
    change = 'Change'
    reservation = 'Reservation'
    execution = 'Execution'
    authorization = 'Authorization'


class ServiceState(str, Enum):
    """
    https://aeroclub.atlassian.net/wiki/spaces/LINK/pages/204734502
    """
    unknown = 'Unknown'  # черновик
    reservation = 'Reservation'  # забронировано
    refunding = 'Refunding'  # отменено
    servicing = 'Servicing'  # обслуживается
    execution = 'Execution'  # оформлено
    exchanged = 'Exchanged'  # обменено
    no_places = 'NoPlaces'  # нет мест
    expired = 'Expired'  # предложение устарело
    rejected = 'Rejected'  # отклонено
    failed = 'Failed'  # отклонено


class ServicingRequest(str, Enum):
    unknown = 'Unknown'  # запрос отсутствует
    reservation = 'Reservation'  # запрос на бронирование
    execution = 'Execution'  # запрос на оформление
    cancellation = 'Cancellation'  # запрос на отмену
    alteration = 'Alteration'  # запрос на изменение
    price_inquiry = 'PriceInquiry'  # запрос на уточнение стоимости
    deferred_execution = 'DeferredExecution'
    room_category_set_up = 'RoomCategorySetUp'  # запрос на уточнение категории номера
    deletion = 'Deletion'  # запрос на удаление услуги


class ACServiceStatus(str, Enum):
    """
    Тут добавлен префикс AC(Aeroclub), чтобы не было конфликта с другим enum ServiceStatus
    """
    draft = 'Draft'
    archived = 'Archived'
    active = 'Active'


class GeoObjectType(str, Enum):
    undefined = 'Undefined'
    airport = 'Airport'
    railway_station = 'RailwayStation'
    city = 'City'
    country = 'Country'


class Time(str, Enum):
    night = 'Night'
    morning = 'Morning'
    afternoon = 'Afternoon'
    evening = 'Evening'


class SearchResultsOrdering(str, Enum):
    optimal = 'Optimal'
    price = 'Price'
    duration = 'Duration'
    by_time = 'ByTime'


class SearchRequestStatus(str, Enum):
    undefined = 'Undefined'
    completed = 'Completed'
    pending = 'Pending'
    in_progress = 'InProgress'
    response_waiting = 'ResponseWaiting'
    search_response_error = 'SearchResponseError'


class SearchOptionStatus(str, Enum):
    pending = 'Pending'
    in_progress = 'InProgress'
    completed = 'Completed'
    search_response_error = 'SearchResponseError'


class SearchMode(str, Enum):
    undefined = 'Undefined'
    corporate_and_fast = 'CorporateAndFast'
    corporate_and_slow = 'CorporateAnSlow'
    noncorporate_and_fast = 'NoncorporateAndFast'
    noncorporate_and_slow = 'NoncorporateAndSlow'


class AviaTransfer(str, Enum):
    direct = 'Direct'
    one = 'One'
    two_and_more = 'TwoAndMore'


class AviaRules(str, Enum):
    changeable = 'Changeable'
    refundable = 'Refundable'


class FlightBaggageType(str, Enum):
    undefined = 'NotSet'
    baggage = 'Weight'
    hand = 'Seats'


class AviaCabinClassType(str, Enum):
    undefined = 'NotSet'
    economy = 'Econom'
    business = 'Business'
    first = 'First'
    comfort = 'Comfort'


class TrainCarriageType(str, Enum):
    lux = 'Lux'
    vip = 'Vip'
    coupe = 'Coupe'
    reserved = 'Reserved'
    seat = 'Seat'
    common = 'Common'
    any = 'Any'


class TrainCategory(str, Enum):
    fast = 'Fast'
    high_speed = 'HighSpeed'


class TrainCompartmentGender(str, Enum):
    """ Гендерный тип купе/отсека для перевозки """
    wo_desc = 'WoDesc'
    male = 'Man'
    female = 'Female'
    not_defined = 'NotDefined'
    mixed = 'Mixed'


class TrainCarriageClassOption(str, Enum):
    food = 'Eat'
    newspaper = 'Paper'
    tv = 'Tv'
    transfer = 'Transfer'
    air_conditioner = 'Conditioner'
    bed = 'Bed'
    sanitary_set = 'SanitarySet'
    wifi = 'Wifi'


class HotelPaymentPlace(str, Enum):
    check_in = 'Checkin'
    agency = 'Agency'


class HotelConfirmationType(str, Enum):
    instant = 'InstantConfirmation'
    on_request = 'OnRequest'


class ProfileSex(str, Enum):
    undefined = 'Undefined'
    male = 'Male'
    female = 'Female'


class ProfileStatus(str, Enum):
    active = 'Active'
    inactive = 'Inactive'
    awaiting_authorization = 'AwaitingAuthorization'
    pending_activation = 'PendingActivation'
    unknown = 'Unknown'


class DocumentTypestringEnum(str, Enum):
    passport = 'Passport'
    local_passport = 'LocalPassport'
    national_passport = 'NationalPassport'
    birth_certificate = 'BirthCertificate'
    seaman_passport = 'SeamanPassport'
    military_passport = 'MilitaryPassport'
    visa = 'Visa'
    not_specified = 'NotSpecified'


class EventCode(str, Enum):
    execution_status_succeeded = 'ExecutionStatusSucceeded'
    execution_status_cancelled = 'ExecutionStatusCancelled'
