

class AeroclubError(Exception):
    """
    Базовая ошибка, связанная с Аэроклубом
    """


class AeroclubClientError(AeroclubError):
    """
    API Аэроклуба ответило с ошибкой
    """
    def __init__(self, content: str = None, status_code: int = None):
        self.status_code = status_code
        self.content = content


class AeroclubBadDocument(AeroclubClientError):
    """
    Не получилось добавить документ в услугу
    """


class AeroclubWorkflowError(AeroclubError):
    """
    Что-то пошло не так с воркфлоу Аэроклуба
    """
