from decimal import Decimal
from pydantic import BaseModel

from intranet.trip.src.lib.aeroclub import enums


class Name(BaseModel):
    ru: str = None
    en: str = None


class CodeName(BaseModel):
    code: str = None
    name: Name = None


class ACCountry(CodeName):
    id: int


class ACCity(CodeName):
    id: int
    time_zone_offset: str = None
    country: ACCountry = None


class Company(BaseModel):
    id: int
    company_name: Name = None
    holding_name: Name = None


class ACGeoPosition(BaseModel):
    latitude: Decimal
    longitude: Decimal


class ACAddress(BaseModel):
    name: Name = None
    coordinates: ACGeoPosition = None


class GeoObject(CodeName):
    """Гео-объект, например, город"""
    id: int
    type: enums.GeoObjectType = None
    address: ACAddress = None
    terminal: str = None
    located_in: 'GeoObject' = None
    time_zone_offset: str = None
    image_url: str = None


GeoObject.update_forward_refs()
