from pydantic import BaseModel


class Attachment(BaseModel):
    content_type: str = None
    length: str = None
    name: str = None
    url: str = None


class ACServiceDocument(BaseModel):
    created_at: str = None
    attachments: list[Attachment]
    location: str = None
    ticket_token: str = None


class TravellerDocument(BaseModel):
    id: int
    type: str = None
    first_name: str = None
    last_name: str = None
    middle_name: str = None
    document_number: str = None
