from datetime import datetime, date
from pydantic import BaseModel

from intranet.trip.src.lib.aeroclub.models.common import Company, Name
from intranet.trip.src.lib.aeroclub.models.document import TravellerDocument
from intranet.trip.src.lib.aeroclub.enums import (
    DocumentTypestringEnum,
    ProfileStatus,
    ProfileSex,
)


class ProfileLevel(BaseModel):
    id: int
    name: Name = None
    weight: int = None


class ProfileInfo(BaseModel):
    id: int
    first_name: Name = None
    middle_name: Name = None
    last_name: Name = None
    company_info: Company = None
    avatar_url: str = None
    sex: str = None  # enum
    profile_level: ProfileLevel = None


class ServiceTravellerIn(BaseModel):
    """
    Форма добавления человека в услугу
    """
    profile_id: int
    document_id: int
    bonus_card_id: int = None


class TravellerIn(BaseModel):
    """
    Форма добавления человека при создании командировки
    """
    card_information_store_id: int = None
    company_id: int
    from_city_id: int
    payment_type_id: int
    profile_id: int


class TravellerBonusCard(BaseModel):
    id: int
    number: str


class Traveller(BaseModel):
    id: int
    type: str = None
    internal_identifier: str = None
    profile: ProfileInfo = None
    bonus_card: TravellerBonusCard = None
    documents: list[TravellerDocument] = None
    tickets: list[dict] = None


class AdditionalInfo(BaseModel):
    name_ru: str = None
    name_en: str = None
    value_ru: str = None
    value_en: str = None


class ModelCompany(BaseModel):
    id: int
    company_name: Name = None
    holding_name: Name = None


class EmailAddress(BaseModel):
    address: str = None
    type: str = None


class PhoneNumberContact(BaseModel):
    area_code: str = None
    country_code: str = None
    extension_number: str = None
    phone_number: str = None
    type: str = None


class ProfileContacts(BaseModel):
    email_addresses: list[EmailAddress] = None
    phone_numbers: list[PhoneNumberContact] = None


class ACBonusCard(BaseModel):
    id: int
    bonus_card_code: str = None
    bonus_card_issuer: Name = None
    number: str
    kind_type: str


class ProfileDocument(BaseModel):
    id: int
    issued_on: datetime = None
    citizenship_country: dict = None
    city_of_issue: dict = None
    city_of_issue_id: int = None
    destination_country: dict = None
    expires_on: datetime = None
    first_name: str = None
    last_name: str = None
    master_document_id: int = None
    series: str = None
    number: str
    place_of_birth: str = None
    type: DocumentTypestringEnum


class ProfileDocumentIn(BaseModel):
    type: DocumentTypestringEnum
    series: str
    number: str
    first_name: str
    last_name: str
    place_of_birth: str = None
    citizenship_country_id: int
    issued_on: date
    expires_on: date = None


class Profile(BaseModel):
    """Профиль, получаемый из Аэроклуба"""
    id: int
    first_name: Name = None
    middle_name: Name = None
    last_name: Name = None

    created_at: datetime
    updated_at: datetime = None

    date_of_birth: datetime = None
    sex: ProfileSex
    status: ProfileStatus = None
    is_vip: bool

    photo_fingerprint: str = None
    contacts: ProfileContacts = None
    version: str = None
    company_info: ModelCompany = None
    additional_info: list[AdditionalInfo] = None

    bonus_cards: list[ACBonusCard] = None
    documents: list[ProfileDocument] = None
