from pydantic import BaseModel

from intranet.trip.src.lib.aeroclub import enums
from intranet.trip.src.lib.aeroclub.models.common import Name, GeoObject


class Reference(BaseModel):
    """Объект саджеста по справочникам (города, страны)"""
    id: int
    code: str = None
    name: Name = None
    type: enums.ReferenceType = None
    located_in: GeoObject = None
    city: GeoObject = None
    address: Name = None
