from fastapi import Query
from pydantic import BaseModel
from pydantic.dataclasses import dataclass

from intranet.trip.src.lib.aeroclub import enums
from intranet.trip.src.lib.aeroclub.models.common import CodeName


class FilterParameter(BaseModel):
    parameter_name: str
    values: list[CodeName]


@dataclass
class SearchFilter:
    times: enums.Time = None
    orderBy: enums.SearchResultsOrdering = None
    isDescending: bool = None
    departureAtThereTimes: list[enums.Time] = Query(None)
    arrivalAtThereTimes: list[enums.Time] = Query(None)
    departureAtBackTimes: list[enums.Time] = Query(None)
    arrivalAtBackTimes: list[enums.Time] = Query(None)

    departureFromThere: list[str] = Query(None)
    arrivalToThere: list[str] = Query(None)
    departureFromBack: list[str] = Query(None)
    arrivalToBack: list[str] = Query(None)

    IsTravelPolicyCompliant: bool = None
    IsCorporateTariff: bool = None

    # avia filters
    aviaFilter_airCompanies: list[str] = Query(None)
    aviaFilter_classes: list[str] = Query(None)
    aviaFilter_transfer: list[enums.AviaTransfer] = Query(None)
    aviaFilter_baggage: bool = None
    aviaFilter_rules: list[enums.AviaRules] = Query(None)
    aviaFilter_isGroupedByFareFamily: bool = None

    # rail filters
    railFilter_carriageTypes: list[enums.TrainCarriageType] = Query(None)
    railFilter_trainName: list[str] = Query(None)
    railFilter_trainCategories: list[enums.TrainCategory] = Query(None)
    railFilter_electronicRegistration: bool = None
    railFilter_carriageOwners: list[str] = Query(None)
    railFilter_branded: bool = None

    # hotel filters
    hotelFilter_stars: list[str] = Query(None)
    hotelFilter_priceFrom: int = None
    hotelFilter_priceTo: int = None
    hotelFilter_hotelTypes: list[str] = Query(None)
    hotelFilter_paymentPlaces: list[enums.HotelPaymentPlace] = Query(None)
    hotelFilter_confirmationTypes: list[enums.HotelConfirmationType] = Query(None)
    hotelFilter_isRecommended: bool = None
    hotelName: str = None
