from datetime import date
from pydantic import BaseModel

from intranet.trip.src.lib.aeroclub import enums
from intranet.trip.src.lib.aeroclub.models.common import GeoObject
from intranet.trip.src.lib.aeroclub.models.profile import ProfileInfo, ProfileLevel
from intranet.trip.src.lib.aeroclub.models.search_result import SearchResultVariantsCount


class SearchOptionIn(BaseModel):
    """Форма опции поиска в поисковом запросе"""
    service_type: enums.ACServiceType
    comment: str
    departure_city_id: int = None
    arrival_city_id: int
    checkin_on: date = None
    checkout_on: date = None
    departure_on: date = None
    number: int
    round_trip_departure_on: date = None
    search_mode: list[enums.SearchMode] = None


class SearchOption(SearchOptionIn):
    number: int
    service_type: enums.ACServiceType
    status: enums.SearchOptionStatus
    comment: str = None
    departure_city_id: int = None
    arrival_city_id: int = None
    checkin_on: str = None
    checkout_on: str = None
    departure_on: str = None
    round_trip_departure_on: str = None
    arrival_city: GeoObject = None
    departure_city: GeoObject = None


class SearchRequestId(BaseModel):
    request_id: int


class ACSearchRequestStatus(BaseModel):
    status: enums.SearchRequestStatus


class SearchRequestIn(BaseModel):
    """Форма поискового запроса"""
    departure_city_id: int
    arrival_city_id: int
    departure_on: date
    round_trip_departure_on: date = None
    profile_id: int = None
    options: list[SearchOptionIn]


class SearchRequest(BaseModel):
    number: int
    company_id: int
    status: enums.SearchRequestStatus
    is_active: bool
    is_expired: bool
    is_read: bool

    arrival_city: GeoObject = None
    departure_city: GeoObject = None

    departure_on: str = None
    round_trip_departure_on: str = None
    created_at_utc: str
    updated_at_utc: str
    expires_at_utc: str = None

    options: list[SearchOption]
    profile: ProfileInfo = None
    profile_level: ProfileLevel = None
    requested_by: ProfileInfo = None

    results_count: SearchResultVariantsCount
