from decimal import Decimal
from pydantic import BaseModel, validator

from intranet.trip.src.lib.aeroclub import enums
from intranet.trip.src.lib.aeroclub.models.document import ACServiceDocument
from intranet.trip.src.lib.aeroclub.models.profile import Traveller


class ServiceLite(BaseModel):
    authorization_assertion: enums.AuthorizationAssertion = None
    authorization_status: enums.AuthorizationStatus = None
    available_actions: list[enums.ServiceAction] = None
    start_at: str = None
    start_at_utc: str = None
    end_at: str = None
    end_at_utc: str = None
    number: int = None
    order_number: int = None
    service_state: enums.ServiceState = None
    service_request: enums.ServicingRequest = None
    status: enums.ACServiceStatus = None
    tariff_total: Decimal = None
    type: enums.ACServiceType = None
    unique_identifier: str = None

    @validator('available_actions', pre=True)
    def split_actions(cls, v):
        return [action.strip() for action in v.split(',')]


class ACService(ServiceLite):
    """Услуга (авиа, поезд или отель)"""
    documents: list[ACServiceDocument] = None
    travellers: list[Traveller] = None
    reservation_expires_at: str = None
    reservation_expires_at_utc: str = None
    reservation_token: str = None
    raw: dict = None
