from datetime import date
from pydantic import BaseModel

from intranet.trip.src.lib.aeroclub import enums
from intranet.trip.src.lib.aeroclub.models.common import Company, GeoObject
from intranet.trip.src.lib.aeroclub.models.profile import ProfileInfo, TravellerIn
from intranet.trip.src.lib.aeroclub.models.service import ServiceLite


class JourneyIn(BaseModel):
    """Форма создания командировки (групповой)"""
    starts_on: date
    ends_on: date
    to_city_id: int
    travellers: list[TravellerIn]


class BusinessTrip(BaseModel):
    """
    Персональная командировка. Соответствует нашему PersonTrip.
    """
    authorization_assertion: enums.AuthorizationAssertion = None
    authorization_status: enums.AuthorizationStatus = None
    company: Company = None
    created_at: str = None
    created_by: ProfileInfo = None
    ends_on: str = None
    from_city: GeoObject = None
    has_documents: bool = None
    journey_number: int = None
    number: int = None
    services: list[ServiceLite] = None
    starts_on: str = None
    to_city: GeoObject = None
    traveller: ProfileInfo = None
