from abc import ABC, abstractmethod
from aioredis_lock import RedisLock

from intranet.trip.src.config import settings


class BaseEventHandler(ABC):
    def __init__(self, uow):
        self.uow = uow

    @abstractmethod
    async def process(self, event):
        raise NotImplementedError()

    async def run_handler(self, event):
        return await self.process(event)


class BaseBlockingEventHandler(BaseEventHandler, ABC):
    LOCK_PREFIX = 'lock'

    @abstractmethod
    def get_unique_handler_name(self, event):
        raise NotImplementedError()

    async def run_handler(self, event):
        key = f'{self.LOCK_PREFIX}:{self.get_unique_handler_name(event)}'
        async with RedisLock(
            pool_or_conn=self.uow._redis,
            key=key,
            wait_timeout=settings.REDIS_LOCK_WAIT_TIMEOUT,
            timeout=settings.REDIS_LOCK_TIMEOUT,
        ):
            await self.process(event)
