from intranet.trip.src.lib.aeroclub.notifications.base import BaseBlockingEventHandler
from intranet.trip.src.lib.registry import Registry
from intranet.trip.src.logic.aeroclub.services import AeroclubServiceProcessor


handler_registry = Registry()


# Короткое описание событий: https://wiki.yandex-team.ru/trip/dev/back/ac-events/
@handler_registry.add(
    'ServiceDraftToActive',
    'ServicingRequestReservation',
    'ServicingRequestExecution',
    'ServicingRequestCancellation',
    'ServicingRequestAlteration',
    'ServicingRequestDeletion',
    'ExecutionStatusSucceeded',
    'ExecutionStatusCancelled',
    'ExecutionStatusExchanged',
    'ExecutionStatusDeleted',
    'ExecutionStatusRejectExecution',
    'ServicePriceChanged',
    'ServiceConfirmationDocuments',
)
class ServiceEventHandler(BaseBlockingEventHandler):
    def get_unique_handler_name(self, event):
        return f'{event["aeroclub_journey_id"]}_{event["aeroclub_trip_id"]}'

    async def process(self, event):
        service = event['services'][0]
        service_processor = await AeroclubServiceProcessor.init(
            uow=self.uow,
            provider_order_id=service['provider_order_id'],
            provider_service_id=service['provider_service_id'],
        )
        await service_processor.run()
