from enum import Enum


class ClassAvia(str, Enum):
    economy = 'e'
    business = 'b'
    first_class = 'f'
    comfort = 'a'


class PassengerAge(str, Enum):
    adult = 'adt'  # больше 18 лет
    child = 'chd'  # от 2 до 18 лет
    infant = 'inf'  # до 2 лет


class PassengerGender(str, Enum):
    male = 'M'
    female = 'F'


class CabinGender(str, Enum):
    male = 'М'
    female = 'Ж'
    mixed = 'С'
    undefined = 'Ц'


class DocumentTypeCode(str, Enum):
    russian_passport = 'C'  # Паспорт РФ
    russian_international_passport = 'P'  # Загранпаспорт РФ
    international_passport = 'A'  # Иностранный документ, включая локальные паспорта других стран


class AviaSortField(str, Enum):
    price = 'price'
    duration = 'duration'
    departure_time = 'departure_time'
    arrival_time = 'arrival_time'


class HotelSortField(str, Enum):
    price = 'price'
    contract = 'contract'
    favorite = 'favorite'


class TrainSortField(str, Enum):
    price = 'price'
    duration = 'duration'
    departure_time = 'departure_time'
    arrival_time = 'arrival_time'


class SortDirection(str, Enum):
    asc = 'ASC'
    desc = 'DESC'


class TrainCarType(str, Enum):
    lux = 'ЛЮКС'       # Люкс
    coupe = 'КУПЕ'     # Купе
    reserved = 'ПЛАЦ'  # Плацкарт
    seat = 'СИД'       # Сидячий
    common = 'ОБЩ'     # Общий
    soft = 'СВ'        # Мягкий


class TrainCarTypeDisplay(str, Enum):
    lux = 'Люкс'
    coupe = 'Купе'
    reserved = 'Плацкарт'
    seat = 'Сидячий'
    common = 'Общий'
    soft = 'СВ'


class TrainCategory(str, Enum):
    passenger = 'Пассажирский'
    branded = 'Фирменный'
    fast = 'Скорый'
    express_branded = 'Скорый Фирменный'
    high_speed = 'Скоростной'
    high_speed_branded = 'Скоростной Фирменный'
    very_high_speed = 'Высокоскоростной'


class TrainRoutePolicy(str, Enum):
    internal = 'Internal'
    finland = 'Finland'
    international = 'International'


class TrainReservationPolicy(str, Enum):
    usual = 'Usual'
    two_places_at_once = 'TwoPlacesAtOnce'
    four_places_at_once = 'FourPlacesAtOnce'


class TrainLoyaltyCard(str, Enum):
    universal = 'UniversalCard'
    bonus = 'BonusCard'


class TrainPlaceType(str, Enum):
    undefined = 'NoValue'
    no_place = 'WithoutPlace'
    lower = 'Lower'
    upper = 'Upper'
    third_shelf = 'ThirdShelf'
    side_lower = 'SideLower'
    side_upper = 'SideUpper'
    side_lower_near_restroom = 'SideLowerNearRestroom'
    side_upper_near_restroom = 'SideUpperNearRestroom'
    side_lower_with_noise = 'SideLowerWithHigherLevelOfNoise'
    side_upper_with_noise = 'SideUpperWithHigherLevelOfNoise'
    last_compartment_lower = 'LastKupeLower'
    last_compartment_upper = 'LastKupeUpper'
    last_compartment_lower_noise = 'LastCompartmentLowerWithHigherLevelOfNoise'
    last_compartment_upper_noise = 'LastCompartmentUpperWithHigherLevelOfNoise'
    two_place_compartment_lower = 'LowerInTwoPlaceCompartment'
    two_place_compartment_upper = 'UpperInTwoPlaceCompartment'
    with_pets = 'WithPets'
    near_pets = 'NearPassengersWithPets'
    with_child = 'WithChild'
    mother_and_child = 'MotherAndBaby'
    near_playground = 'NearPlayground'
    with_bicycle = 'WithBicycle'
    disabled = 'Invalids'
    disabled_lower = 'InvalidsLower'
    disabled_upper = 'InvalidsUpper'
    near_table = 'NearTable'
    near_table_forward = 'NearTableForward'
    near_table_backward = 'NearTableBackward'
    near_table_near_playground = 'NearTablePlayground'
    no_table = 'NotNearTable'
    no_table_usual = 'Usual'
    no_table_forward = 'NoTableForward'
    no_table_backward = 'NoTableBackward'
    no_table_no_window = 'NoTableAndNoWindow'
    no_window_forward = 'NoWindowForward'
    no_window_backward = 'NoWindowBackward'
    single_forward = 'SingleForward'
    foldable = 'Foldable'  # Откидное или неудобное :)
    foldable_or_with_noise = 'FoldableOrWithHigherLevelOfNoise'
    negotiation_room = 'Negotiations'
    with_noise = 'WithHigherLevelOfNoise'
    near_restroom = 'NearRestroom'
    foldable_near_restroom = 'FoldableNearRestroom'
    near_restroom_backward = 'NearRestroomAndBackward'
    near_restroom_forward = 'NearRestroomAndForward'
    passageway = 'AisleSeat'
    passageway_with_noise = 'AisleSeatWithHigherLevelOfNoise'
    separate_compartment = 'SeparateCompartment'
    middle = 'Middle'
    side = 'Side'


class TrainCarService(str, Enum):
    bed = 'Bedclothes'
    food = 'Meal'
    wifi = 'Wifi'
    tv = 'Tv'
    sanitary_set = 'HygienicKit'
    newspaper = 'Press'
    air_conditioner = 'AirConditioning'
    bio_toilet = 'BioToilet'
    blanket = 'Plaid'
    sink_in_compartment = 'WashbasinInCompartment'
    shower_in_compartment = 'ShowerRoomInCompartment'
    hygienic_shower = 'HygienicShower'
    socket_220 = 'Socket220V'
    slippers = 'Slipper'
    pets = 'PetsCarriage'
    baby = 'PlacesForPassengerWithBaby'
    transfer = 'Transfer'
    restaurant_car = 'RestaurantCarOrBuffet'
    luggage_compartment = 'LuggageCompartment'
    shower_in_train = 'ShowerRoomInTrain'
    safe = 'Safe'
    improved_service = 'ImprovedServices'
    comfortable_waiting_room = 'HighComfortWaitingRoomServices'
    multimedia_portal = 'InfotainmentService'
    hot_drinks = 'HotDrink'
    socket_usb = 'UsbSocket'
    sightseeing_service = 'ExcursionService'
    panoramic_view = 'PanoramicSalon'


class AviaClassType(str, Enum):
    economy = 'E'
    business = 'B'
    first = 'F'
