

class AviaCenterError(Exception):
    """
    Базовая ошибка, связанная с AviaCenter
    """
    def __init__(
            self,
            content: str = None,
            status_code: int = 200,
            error_code: int = None,
            pid: str = None,
    ):
        """
        :param content: текст ошибки
        :param status_code: http-статус ответа
        :param error_code: внутренний код ошибки Авиацентра
        :param pid: id запроса Авиацентра для обращения в саппорт
        """
        self.status_code = status_code
        self.content = content
        self.pid = pid
        self.error_code = error_code
