from datetime import date
from pydantic import BaseModel
from intranet.trip.src.lib.aviacenter import enums
from intranet.trip.src.lib.aviacenter.fields import boolint


class BonusCardIn(BaseModel):
    supplier: str  # TODO: Просто строка?
    number: str


class PassengerIn(BaseModel):
    age: enums.PassengerAge = enums.PassengerAge.adult
    document_number: str
    document_type_code: enums.DocumentTypeCode
    citizenship: str  # В двухбуквенном формате (RU)
    last_name: str  # латиница
    first_name: str  # латиница
    middle_name: str = None  # латиница
    last_name_ru: str = None  # кириллица
    first_name_ru: str = None  # кириллица
    middle_name_ru: str = None  # кириллица
    birthday: date
    gender: enums.PassengerGender
    email: str
    phone: str
    save_person: boolint = 0
    send_email: boolint = 0
    include_online_registration: boolint = 1
    bonus_card: BonusCardIn = None


class AviaBookIn(BaseModel):
    company_id: int
    travel_policy_id: int = None
    tid: str
    group_billing_number: int = None
    # В Авиацентре это contact_type - это enum {me, passengers, all}
    # Но нам, кажется, всегда нужен passengers
    # Это значит, что в случае информирования об изменениях в рейсе
    # поставщик будет связываться непосредственно с пассажиром
    contact_type: str = 'passengers'
    passengers: list[PassengerIn]
    is_draft: boolint
