from datetime import date
from pydantic import BaseModel

from intranet.trip.src.lib.aviacenter import enums
from intranet.trip.src.lib.aviacenter.fields import boolint


class HotelGuest(BaseModel):
    type: enums.PassengerAge = enums.PassengerAge.adult
    first_name: str  # Имя гостя на латинице
    last_name: str  # Фамилия гостя на латинице
    first_name_ru: str = None
    last_name_ru: str = None
    age: int = None
    birthday: date = None  # обязательно, если save_person = 1
    gender: enums.PassengerGender
    save_person: boolint = 0
    is_private_person: boolint = 0
    send_email: boolint = 0
    email: str = None  # обязательно, если send_email = 1
    citizenship: str  # В двухбуквенном формате (RU)
    attributes: list = None  # список id/value


class HotelRoom(BaseModel):
    rate_id: str
    guests: list[HotelGuest]


class HotelBookIn(BaseModel):
    company_id: int
    travel_policy_id: int = None
    hotel_id: str
    price: int  # зачем это нужно передавать?
    search_id: str
    use_private_person_invoice: boolint = 0  # нужно ли нам это передавать
    billing_number: int = None
    group_billing_number: int = None
    comment: str = None  # комментарий к авторизации, нам не нужен?
    confirm_duplicated_booking: boolint = 1  # ?
    is_draft: boolint = 1  # бронь является черновиком
    attributes: list = None  # список id/value
    rooms: list[HotelRoom]
