import logging
import json

from async_clients.clients.base import BaseClient

from intranet.trip.src.config import settings

logger = logging.getLogger(__name__)


class HubError(Exception):
    pass


class Hub(BaseClient):

    USE_ZORA = settings.ENABLE_ZORA
    RESPONSE_TYPE = 'text'
    RETRY_CODES = {
        499,
        502,
        503,
        504,
    }

    def get_headers(self):
        return {
            'Content-Type': 'application/vnd.aeroclub.integration-hub.profiles.v1+xml',
            'User-Agent': 'Trip Application <hello@example.com>',
            'Authorization': f'Basic {settings.hub_api_token}',
        }

    async def push_one_profile(self, data: str) -> str:
        result = await self._make_request(
            method='post',
            path='profiles/synchronization/single',
            data=data,
        )
        return result

    async def push_many_profiles(self, data: str) -> str:
        result = await self._make_request(
            method='post',
            path='profiles/synchronization/batch',
            data=data,
        )
        return result

    async def get_synchronization_status(self, batch_id: str) -> dict:
        result = await self._make_request(
            method='get',
            path='profiles/synchronization/status',
            params={
                'uniqueIdentifier': batch_id,
                'format': 'json',
            }
        )
        return json.loads(result)
