import enum
from intranet.trip.src.enums import DocumentType


HUB_DOCUMENT_TYPES = {
    DocumentType.passport,
    DocumentType.external_passport,
}


class HubSyncStatus(str, enum.Enum):
    IN_PROGRESS = 'InProgress'
    COMPLETED = 'Completed'
    FAILED = 'Failed'


class ProfileSyncStatus(str, enum.Enum):
    UNKNOWN = 'Unknown'
    PENDING = 'Pending'
    FAILED = 'Failed'
    UPDATED = 'ProfileUpdated'
    CREATED = 'ProfileCreated'

    synced_statuses = {UPDATED, CREATED}
