import logging
from typing import Any

from async_clients.clients.base import BaseClient
from async_clients.auth_types import TVM2


logger = logging.getLogger(__name__)


class IntrasearchClient(BaseClient):

    AUTH_TYPES = {TVM2}

    async def suggest(self, text: str, version: int = 2, limit: int = 8) -> dict[str, Any]:
        params = {
            'version': str(version),
            'layers': 'people',
            'people.per_page': str(limit),
            'text': text,
        }
        return await self._make_request(
            method='get',
            path='/suggest/',
            params=params,
        )
