from jinja2 import Template
from library.python import resource

from intranet.trip.src.lib.messenger.api import bot_messenger


async def notify_by_messenger(
    chat_id: str,
    text: str = None,
    template_name: str = None,
    context: dict = None,
) -> None:
    if text is None:
        path = 'intranet/trip/src/templates/messenger/' + template_name
        template = resource.resfs_read(path).decode('utf-8')
        context = context or {}
        text = Template(template).render(**context)
    await bot_messenger.send_message(chat_id=chat_id, text=text)
