import aiohttp
import logging
from typing import Any
from tenacity import TryAgain

from async_clients.clients.base import BaseClient
from async_clients.auth_types import OAuth

from intranet.trip.src.lib.ok.exceptions import OkError


logger = logging.getLogger(__name__)


class OkClient(BaseClient):

    AUTH_TYPES = {OAuth}

    async def parse_response(self, response: aiohttp.ClientResponse, **kwargs) -> dict:
        if response.status in self.RETRY_CODES:
            raise TryAgain()
        if response.status >= 400:
            message = (
                f'Got status: {response.status}, for request: '
                f'{response.method} {response.url}'
            )
            logger.info(message)
            content = await response.json()
            if 'already_exists' in (it.get('code') for it in content.get('error', [])):
                return {}
            raise OkError(status_code=response.status, content=content)

        return await getattr(response, self.RESPONSE_TYPE)()

    async def create_approvement(self, data: dict[str, Any]) -> dict[str, Any]:
        return await self._make_request(
            method='post',
            path='/api/approvements/',
            json=data,
        )
