from intranet.trip.src.api.auth import get_tvm_service_ticket
from intranet.trip.src.config import settings
from intranet.trip.src.lib.passport.api import (
    BaseContactsApiClient,
    BaseDocumentsApiClient,
    ContactsApiClient,
    DocumentsApiClient,
)


class PassportApiGateway:
    def __init__(
        self,
        contacts: BaseContactsApiClient,
        documents: BaseDocumentsApiClient,
    ):
        self.contacts = contacts
        self.documents = documents

    @classmethod
    async def init(cls, user_ticket: str = None):
        return cls(
            contacts=ContactsApiClient(
                host=settings.passport_contacts_api_url,
                service_ticket=await get_tvm_service_ticket('passport-contacts'),
            ),
            documents=DocumentsApiClient(
                host=settings.document_api_url,
                service_ticket=await get_tvm_service_ticket('passport'),  # FIXME: if it need
                user_ticket=user_ticket,
            ),
        )
