from typing import Optional, Mapping
from enum import Enum

from async_clients.clients.base import ZORA_HOST

from intranet.trip.lib.asgi_log_middleware import BaseProfilingClient

from intranet.trip.src.api.auth import get_tvm_service_ticket
from intranet.trip.src.config import settings


class BaseServiceProviderClient(BaseProfilingClient):

    USE_ZORA = settings.ENABLE_ZORA

    async def _make_request(self, **kwargs):
        if self.USE_ZORA:
            # За время работы с клиентом сервисный тикет может протухнуть,
            # поэтому здесь он обновляется при каждом запросе
            self.kwargs['service_ticket'] = await get_tvm_service_ticket('zora')

        return await super()._make_request(**kwargs)

    def get_proxy_params(self):
        if self.USE_ZORA:
            return ZORA_HOST, {'X-Ya-Service-Ticket': self.kwargs.get('service_ticket')}
        return None, None

    def _cast_param(self, param_value):
        if isinstance(param_value, bool):
            return str(param_value).lower()
        elif isinstance(param_value, Enum):
            return param_value.value
        elif isinstance(param_value, (list, tuple)):
            return [self._cast_param(val) for val in param_value]
        else:
            return str(param_value)

    def _prepare_params(self, params: Optional[dict]) -> Mapping:
        params = params or {}
        result = {}

        for key, value in params.items():
            if value is None:
                continue
            result[key] = self._cast_param(value)

        return result
