class Registry:
    def __init__(self):
        self.registry = {}

    def add(self, *keys):
        def decorator(class_to_add):
            for key in keys:
                self.registry[key] = class_to_add
            return class_to_add
        return decorator

    def __getattr__(self, item):
        return self[item]

    def __getitem__(self, item):
        return self.registry[item]

    def get(self, item, default=None):
        try:
            return self[item]
        except KeyError:
            return default
