import logging
from typing import Any

from async_clients.clients.base import BaseClient
from async_clients.auth_types import TVM2

from intranet.trip.src.lib.samsara.models import SamsaraMessageRequest


logger = logging.getLogger(__name__)


class SamsaraClient(BaseClient):

    AUTH_TYPES = {TVM2}

    async def create_message(self, data: SamsaraMessageRequest) -> dict[str, Any]:
        return await self._make_request(
            method='post',
            path='/api/integration/ya_secondment/v1/message/',
            json=data,
        )
